package com.android.browser;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

import android.util.Log;

public class UserAgentThread extends Thread{

    private Socket socket;
    private static final int DEFAULT_BROWSER_PORT = 49305;//DEFAULT_BROWSER_UA_PORT 
    private static final String TAG = "USER AGENT THREAD";
    private boolean isDesktopUserAgent;
    
    public UserAgentThread(boolean isDesktopUserAgent){
        this.isDesktopUserAgent = isDesktopUserAgent;
    }
    
    @Override
    public void run(){

        if(connect()){
//          Log.i(TAG, "successfully connected to browser server.");
            sendAnalogValue();
        }else{
            Log.e(TAG, "Failed to connect to platform.");
        }
        
        close();
    }
    
    /**
     * Just sending results, try once, else fail
     * @return
     */
    private boolean connect() {

        // try to get local address
        InetAddress address = null;
        try {
            address = InetAddress.getByName("127.0.0.1");
        } catch (UnknownHostException e) {
            Log.e(TAG, "Unknown host", e);
            return false;
        }
        if (address == null) {
            Log.e(TAG,
                    "No address, could not connect. Make sure internet is enabled.");
            return false;
        }

        try {
            socket = new Socket(address, DEFAULT_BROWSER_PORT);
            if (socket != null && socket.isConnected()) {
                return true;
            }
        } catch (UnknownHostException e) {
            Log.e(TAG, "Unknown host", e);

        } catch (IOException e) {
            Log.e(TAG,
                    "Can not connect to server on localhost:" + DEFAULT_BROWSER_PORT, e);
        }

        Log.e(TAG, "Client could not connect to iplink server");
        
        return false;
    }

    /**
     * Close socket connection
     */
    private void close() {
        if (socket != null) {
            try {
                socket.getInputStream().close();
                socket.close();
            } catch (IOException e) { 
                // I/0 don't care! I/0 love it
            }
            socket = null;
        }

    }
    private void sendAnalogValue(){

        byte[] buffer = new byte[9];

        byte cipBytesToFollow        = (byte)(6);
        byte cresnetBytesToFollow = (byte)(3);

        //CIP HEADER
        buffer[0]= 0x05;
        buffer[1]= 0x00;
        buffer[2]= cipBytesToFollow;//bytes to follow
        buffer[3]= 0x00;
        buffer[4]= 0x00;

        //CRESNET HEADER
        buffer[5]= cresnetBytesToFollow;//bytes to follow
        buffer[6]= 0x00;//type is digital
        
        //join - 28602 and 28603  (needs to be -1)
        //6FBF       6FC0   <- swapped
        buffer[7]= isDesktopUserAgent?(byte)0xBA:(byte)0xB9;
        buffer[8]= (byte)0x6F;//6F is pressed, EF on release
        
        writeToOutputStream(buffer);

    }
   
    private void writeToOutputStream(byte[] buffer){

        OutputStream bos;

        if(socket == null){
            Log.e(TAG, "socket can not be null. Analog Join not sent");
            return;
        }
//        StringBuilder builder = new StringBuilder();
//        builder.append("Sending values to browser server: ");
//        for(int i =0; i < buffer.length ; i++){
//          builder.append(String.format("%02x", buffer[i]&0xff) + " ");
//        }
//        Log.i(TAG, builder.toString() + "\n");
        
        try {
            bos = socket.getOutputStream();
            bos.write(buffer);
            bos.flush();

            Log.i(TAG, "successfully wrote user agent value to the platform.");
        } catch (IOException e) {
            Log.e(TAG, "Could not connect.", e);
        }

    }

}

